<?php
// app/Models/ProductTransfer.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductTransfer extends Model
{
    protected $fillable = [
        'reference', 'from_branch_id', 'to_branch_id', 'user_id', 'notes', 'status', 'pending_at', 'in_transit_at', 'completed_at', 'canceled_at'
    ];

    public function fromBranch()
    {
        return $this->belongsTo(Branch::class, 'from_branch_id');
    }

    public function toBranch()
    {
        return $this->belongsTo(Branch::class, 'to_branch_id');
    }

    public function details()
    {
        return $this->hasMany(ProductTransferItem::class);
    }
}
