<?php

// app/Models/ProductTransferItem.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductTransferItem extends Model
{
    protected $fillable = [
        'product_transfer_id', 'product_id', 'variant_id', 'quantity', 'product_name', 'size', 'color'
    ];

    public function transfer()
    {
        return $this->belongsTo(ProductTransfer::class, 'product_transfer_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function product_variant()
    {
        return $this->belongsTo(ProductVariant::class, 'variant_id', 'id');
    }
}
