<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductVariant extends Model
{
    protected $fillable = [
        'product_id',
        'size_id',
        'color_id',
        'purchase_price',
        'price',
        'min_stock',
        'min_price',
        'stock', 
        'main_image',
        'supplier_barcode',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id', '');
    }

    public function color()
    {
        return $this->belongsTo(Color::class);
    }

    public function size()
    {
        return $this->belongsTo(Size::class);
    }

    public function purchases_detail()
    {
        return $this->hasMany(PurchaseDetail::class, 'variant_id');
    }

    public function sales_detail()
    {
        return $this->hasMany(SaleDetail::class, 'variant_id');
    }

    public function product_tranfer_items()
    {
        return $this->hasMany(ProductTransferItem::class, 'variant_id');
    }

    public function branch_stocks() 
    {
        return $this->hasMany(BranchProductStock::class, 'product_variant_id');
    }
}
