<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Proforma extends Model
{
    protected $fillable = [
        'customer_id',
        'user_id',
        'status',
        'total',
        'has_furniture_service',
        'delivery_date',
        'user_id_served',
    ];

    public function items()
    {
        return $this->hasMany(ProformaItem::class);
    }

    public function furnitures()
    {
        return $this->hasMany(FurnitureService::class);
    }

    public function customer()
    {
        return $this->belongsTo(Client::class, 'customer_id', 'id');
    }

    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }
}
