<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProformaItem extends Model
{
    protected $fillable = [
        'proforma_id',
        'product_id',
        'product_variant_id',
        'main_image',
        'product_name',
        'size',
        'color',
        'custom_name',
        'custom_description',
        'custom_measurements',
        'custom_image',
        'quantity',
        'price',
    ];

    // Relación con la proforma
    public function proforma()
    {
        return $this->belongsTo(Proforma::class);
    }

    // Relación con la proforma
    public function branch()
    {
        return $this->belongsTo(Branch::class, 'sold_from_branch_id');
    }

    // Relación con producto (si es referencia)
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    // Relación con variante (si aplica)
    public function variant()
    {
        return $this->belongsTo(ProductVariant::class, 'product_variant_id');
    }

    public function branchStocks()
    {
        return $this->hasMany(BranchProductStock::class, 'product_id');
    }

    /**
     * Devuelve el nombre del producto, ya sea del catálogo o personalizado
     */
    public function getDisplayNameAttribute()
    {
        if ($this->product) {
            return $this->product->name . ($this->variant ? " ({$this->variant->size->name} - {$this->variant->color->name})" : '');
        }

        return $this->custom_name ?? 'Producto personalizado';
    }
}
