<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Purchase extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', 'supplier_id', 'invoice_number', 'status', 'total_amount', 'payment_status', 'order_status', 
        'new_at', 'confirmed_at', 'to_pickup_at', 'stored_at', 'unpaid_at', 'partial_at', 'paid_at'
    ];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }

    public function details()
    {
        return $this->hasMany(PurchaseDetail::class);
    }

    public function payments()
    {
        return $this->hasMany(PurchasePayment::class);
    }
}
