<?php
  
namespace App\Models;
  
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Role extends Model
{
    use HasFactory;
  
    /**
     * The attributes that are mass assignable.
     *	
     * @var array
     */
    protected $fillable = [
        'user_id', 'name', 'guard_name'
    ];


    // Atributos calculados que siempre aparecerán en JSON
    protected $appends = ['is_used'];

    /**
     * Relación con model_has_roles
     * (aquí indicamos la tabla intermedia de Spatie)
     */
    public function modelRoles()
    {
        return $this->hasMany(\Spatie\Permission\Models\ModelHasRole::class, 'role_id', 'id');
    }

    /**
     * O, si quieres acceder directamente a los usuarios relacionados
     * (funciona si el guard_name es "web" y el modelo es App\Models\User)
     */
    public function users()
    {
        return $this->belongsToMany(
            \App\Models\User::class,
            'model_has_roles',
            'role_id',
            'model_id'
        );
    }

    /**
     * Campo calculado: indica si el rol está en uso (asignado a algún usuario)
     */
    public function getIsUsedAttribute(): bool
    {
        return $this->users()->exists();
    }
}
 