<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sale extends Model
{
    use HasFactory;

    protected $fillable = ['cash_register_id', 'branch_id', 'user_id', 'customer_id', 'status', 'total', 'advance_payment', 'new_date', 'status', 'completed_date'];

    // Relación con el cliente
    public function customer()
    {
        return $this->belongsTo(Client::class, 'customer_id', 'id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    // Relación con los detalles de venta
    public function details()
    {
        return $this->hasMany(SaleDetail::class);
    }

    public function payments()
    {
        return $this->hasMany(SalePayment::class);
    }
        
    public function proforma()
    {
        return $this->hasOne(Proforma::class);
    }
    
    public function setStatus(string $status): void
    {
        $this->status = $status;

        switch ($status) {
            case 'new':
                $this->new_date = now();
                break;
            case 'pending':
                $this->pending_date = now();
                break;
            case 'completed':
                $this->completed_date = now();
                break;
            case 'canceled':
                $this->canceled_date = now();
                break;
        }

        $this->save();
    }
}
