<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SaleDetail extends Model
{
    use HasFactory;

    protected $fillable = [
        'sale_id',
        'product_id',
        'variant_id',
        'product_name',
        'custom_name',
        'custom_description',
        'custom_measurements',
        'size',
        'color',
        'quantity',
        'price',
        'subtotal'
    ];

    // Relación con la venta
    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }
 
    // Relación con el producto
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function product_variant()
    {
        return $this->belongsTo(ProductVariant::class, 'variant_id', 'id');
    }
    
    // Relación con el producto
    public function corrections_items()
    {
        return $this->hasMany(ProductCorrectionItem::class);
    }
}
