<?php

namespace App\Services;

use App\Models\Branch;
use Illuminate\Database\Eloquent\Collection;

class BranchService
{
    public function list($request)
    {
        if ($request->action && $request->action == 'export') {
            return Branch::with("branch_products")
                            ->orderBy('name', 'asc')
                        ->where('name', 'like', '%'. $request->search .'%')
                        ->get();
        }

        return Branch::with("branch_products")
                        ->orderBy('name', 'asc')
                        ->where('name', 'like', '%'. $request->search .'%')
                        ->paginate(20);
    }

    public function getAll(): Collection
    {
        return Branch::all();
    }
 
    public function getById(int $id): ?Branch
    {
        return Branch::find($id);
    }

    public function create(array $data): Branch
    {
        return Branch::create($data);
    }

    public function update($id, $data): ?Branch
    {
        $branch = Branch::find($id);
        if ($branch) {
            $branch->update($data);
        }

        return $branch;
    }

    public function delete(int $id): bool
    {
        $branch = Branch::find($id);
        return $branch ? $branch->delete() : false;
    }
}
