<?php

namespace App\Services;

use App\Models\Brand;
use Illuminate\Database\Eloquent\Collection;

class BrandService
{
    public function list($request)
    {
        if ($request->action && $request->action == 'export') {
            return Brand::with('products', 'user')
                        ->orderBy('name', 'asc')
                        ->where('name', 'like', '%'. $request->search .'%')
                        ->get();
        }

        return Brand::with('products', 'user')
                    ->orderBy('name', 'asc')
                    ->where('name', 'like', '%'. $request->search .'%')
                    ->paginate(20);
    }

    public function getAll(): Collection
    {
        return Brand::orderBy('name', 'asc')->get();
    }

    public function getById(int $id): ?Brand
    {
        return Brand::with('products', 'user')->find($id);
    }

    public function create(array $data): Brand
    {
        $data["description"] = $data["description"] ? $data["description"] : "";

        // aquí ya viene con user_id asignado en el controlador
        return Brand::create($data);
    }

    public function update($id, $data): ?Brand
    {
        $brand = Brand::find($id);

        $data["description"] = $data["description"] ? $data["description"] : "";
        
        if ($brand) {
            $brand->update($data);
        }

        return $brand;
    }

    public function delete(int $id): bool
    {
        $brand = Brand::find($id);
        return $brand ? $brand->delete() : false;
    }
}
