<?php

namespace App\Services;

use App\Models\{ CashRegister, User };
use Illuminate\Support\Facades\DB;

class CashRegisterService
{
    public function list($request)
    {
        if ($request->action && $request->action == 'export') {
            return CashRegister::with(['branch', 'user'])
                            ->where('user_id', $request->user_id)
                            ->orderBy('created_at', 'desc')
                            ->get();
        }

        $user = User::find($request->user_id);

        if ($user->roles[0]->name == "SUPER ADMIN") {
            return CashRegister::with(['branch', 'user'])
                        ->orderBy('created_at', 'desc')
                        ->paginate(20);
        }

        return CashRegister::with(['branch', 'user'])
                        ->where('user_id', $request->user_id)
                        ->orderBy('created_at', 'desc')
                        ->paginate(20);
    }

    public function getById($id): ?CashRegister
    {
        return CashRegister::find($id);
    }

    public function open($data): CashRegister
    {
        return CashRegister::create([
            'user_id' => $data->user_id,
            'branch_id' => $data->branch_id,
            'opening_amount' => $data->opening_amount,
            'opened_at' => now(),
            'status' => 'open',
        ]);
    }

    public function close($id, $userId, $closingAmount): ?CashRegister
    {
        $cashRegister = $this->getById($id);

        $cashRegister->update([
            'closing_amount' => $closingAmount,
            'closing_balance' => $closingAmount + $cashRegister->opening_amount,
            'closed_at' => now(),
            'status' => 'closed',
            'user_id_closed' => $userId,
        ]);

        return $cashRegister;
    }

    public function getByUserFirst($userId)
    {
        return CashRegister::where('user_id', $userId)
                            ->where('status', 'open')
                            ->first();
    }
}
