<?php

namespace App\Services;

use App\Models\Category;
use Illuminate\Database\Eloquent\Collection;

class CategoryService
{
    public function list($request)
    {
        if ($request->action && $request->action == 'export') {
            return Category::with('products')
                        ->orderBy('name', 'asc')
                        ->where('name', 'like', '%'. $request->search .'%')
                        ->get();
        }

        return Category::with('products')
                        ->orderBy('name', 'asc')
                        ->where('name', 'like', '%'. $request->search .'%')
                        ->paginate(20);
    }

    public function getAll(): Collection
    {
        return Category::all();
    }
 
    public function getById(int $id): ?Category
    {
        return Category::find($id);
    }

    public function create(array $data): Category
    {
        return Category::create($data);
    }

    public function update($id, $data): ?Category
    {
        $category = Category::find($id);
        if ($category) {
            $category->update($data);
        }

        return $category;
    }

    public function delete(int $id): bool
    {
        $category = Category::find($id);
        return $category ? $category->delete() : false;
    }
}
