<?php

namespace App\Services;

use App\Models\Client;
use Illuminate\Database\Eloquent\Collection;

class ClientService
{
    public function list($request)
    {
        return Client::with(['sales', 'proformas'])
                        ->orderBy('first_name', 'asc')
                        ->where('identity_card', 'like', '%'. $request->search .'%')
                        ->orWhere('first_name', 'like', '%'. $request->search .'%')
                        ->orWhere('last_name', 'like', '%'. $request->search .'%')
                        ->orWhere('middle_name', 'like', '%'. $request->search .'%')
                        ->paginate(20);
    }

    public function getAll(): Collection
    {
        return Client::all();
    }
 
    public function getById(int $id): ?Client
    {
        return Client::find($id);
    }

    public function create(array $data): Client
    {
        return Client::create($data);
    }

    public function update($id, $data): ?Client
    {
        $client = Client::find($id);
        if ($client) {
            $client->update($data);
        }

        return $client;
    }

    public function delete(int $id): bool
    {
        $client = Client::find($id);
        return $client ? $client->delete() : false;
    }
}
