<?php

namespace App\Services;

use App\Models\Employee;
use Illuminate\Database\Eloquent\Collection;

class EmployeeService
{
    public function list($request)
    {
        if ($request->action && $request->action == 'export') {
            return Employee::with('user')
                        ->orderBy('first_name', 'asc')
                        ->when($request->search, function ($q) use ($request) {
                            $q->where('first_name', 'like', '%'.$request->search.'%')
                              ->orWhere('last_name', 'like', '%'.$request->search.'%')
                              ->orWhere('document_number', 'like', '%'.$request->search.'%');
                        })
                        ->get();
        }

        return Employee::with('user')
                    ->orderBy('first_name', 'asc')
                    ->when($request->search, function ($q) use ($request) {
                        $q->where('first_name', 'like', '%'.$request->search.'%')
                          ->orWhere('last_name', 'like', '%'.$request->search.'%')
                          ->orWhere('document_number', 'like', '%'.$request->search.'%');
                    })
                    ->paginate(20);
    }

    public function getAll(): Collection
    {
        return Employee::orderBy('first_name', 'asc')->get();
    }

    public function getById(int $id): ?Employee
    {
        return Employee::with('user')->find($id);
    }

    public function create(array $data): Employee
    {
        return Employee::create($data);
    }

    public function update($id, $data): ?Employee
    {
        $employee = Employee::find($id);

        if ($employee) {
            $employee->update($data);
        }

        return $employee;
    }

    public function delete(int $id): bool
    {
        $employee = Employee::find($id);
        return $employee ? $employee->delete() : false;
    }
}
