<?php

namespace App\Services;

use App\Models\FurnitureService;
use Illuminate\Database\Eloquent\Collection;

class FurnitureServiceService
{
    public function list($request)
    {
        $query = FurnitureService::with(['proforma.customer', 'customer', 'responsible'])
            ->orderBy('created_at', 'desc');

        if ($request->has('search') && !empty($request->search)) {
            $query->where('notes', 'like', '%' . $request->search . '%');
        }

        if ($request->action && $request->action === 'export') {
            return $query->get();
        }

        return $query->paginate(20);
    }

    public function getAll(): Collection
    {
        return FurnitureService::with(['proforma', 'responsible'])->get();
    }

    public function getById(int $id): ?FurnitureService
    {
        return FurnitureService::with(['proforma', 'responsible'])->find($id);
    }

    public function create(array $data): FurnitureService
    {
        return FurnitureService::create($data);
    }

    public function update($id, $data): ?FurnitureService
    {
        $service = FurnitureService::find($id);
        if ($service) {
            $service->update($data);
        }

        return $service;
    }

    public function delete(int $id): bool
    {
        $service = FurnitureService::find($id);
        return $service ? $service->delete() : false;
    }
}
