<?php

namespace App\Services;

use App\Models\{ ProductCorrectionItem };
use Illuminate\Database\Eloquent\Collection;
use App\Services\{ ProductCorrectionService, SaleDetailService };

use DB;

class ProductCorrectionItemService
{
    protected $productCorrectionService;
    protected $saleDetailService;

    public function __construct(ProductCorrectionService $productCorrectionService, SaleDetailService $saleDetailService)
    {
        $this->productCorrectionService = $productCorrectionService;
        $this->saleDetailService = $saleDetailService;
    }
    
    public function list($request)
    {
        $productsCorrections = ProductCorrectionItem::with('supplier');

        if ($request->start_date && $request->end_date) {
            $startDate = $request->start_date .' 00:00:00';
            $endDate = $request->end_date .' 23:59:59';

            $productsCorrections = $productsCorrections->whereBetween('created_at', [$startDate, $endDate]);
        }

        if ($request->supplier_id) {
            $productsCorrections = $productsCorrections->where('supplier_id', $request->supplier_id);
        }

        if ($request->status) {
            $productsCorrections = $productsCorrections->where('status', $request->status);
        }

        return $productsCorrections->orderBy('created_at', 'desc')->paginate(20);
    }

    public function checkReceived(int $id)
    {
        return DB::transaction(function () use ($id) {
            $productCorrectionItem = ProductCorrectionItem::find($id);
            $productCorrectionItem->status = 'received';
            $productCorrectionItem->save();
            
            $this->productCorrectionService->checkReceived($productCorrectionItem->product_correction_id);

            return true;
        });
    }

    public function toSentList()
    {
        return ProductCorrectionItem::with('sale_detail.sale.customer')->where('status', 'sent')->get();
    }
}
