<?php

namespace App\Services;

use App\Models\{BranchProductStock, ProductVariant };
use Illuminate\Support\Facades\DB;

class ProductVariantService
{  
    public function list($request)
    {
        $productVariants = ProductVariant::with('product')->where('product_id', $request->productId);

        if ($request->size) {
            $productVariants = $productVariants->where('size', $request->size);
        }

        if ($request->color) {
            $productVariants = $productVariants->where('color', $request->color);
        }

        return $productVariants->orderBy('created_at', 'desc')->paginate(20);
    }

    public function getAll()
    {
        return ProductVariant::with('product')->get();
    }

    public function getById(int $id): ?ProductVariant
    {
        return ProductVariant::find($id);
    }

    public function create(array $data): ProductVariant
    {
        return DB::transaction(function () use ($data) {
            // Guardando la imagen principal
            if (isset($data['main_image'])) {
                $image     = $data['main_image'];
                $nameImage = date('YmdHis') .'.'. $image->getClientOriginalExtension();
                $image->move(public_path('img/product-variants'), $nameImage);

                $data['main_image'] = $nameImage;
            }

            $productVariant = ProductVariant::create($data);

            BranchProductStock::create([
                'branch_id' => 1,
                'product_id' => $productVariant->product_id,
                'product_variant_id' => $productVariant->id,
                'stock' => $data['stock'],
            ]);

            return $productVariant;
        });
    }
    
    public function update($id, array $data): ProductVariant
    {
        $productVariant = ProductVariant::find($id);

        if (isset($data['main_image'])) {
            \File::delete(public_path('img/product-variants/'. $productVariant->main_image));

            $image     = $data['main_image'];
            $nameImage = date('YmdHis') .'.'. $image->getClientOriginalExtension();
            $image->move(public_path('img/product-variants'), $nameImage);

            $data['main_image'] = $nameImage;
        } else {
            unset($data['main_image']);
        }
        
        $productVariant->update($data);

        return $productVariant;
    }

    public function delete($id)
    {
        $productVariant = $this->getById($id);

        \File::delete(public_path('img/product-variants/'. $productVariant->main_image));
        
        return $productVariant->delete();
    }

    public function updateStock($purchaseDetail, $type)
    {
        $productVariant = ProductVariant::find($purchaseDetail["variantId"]);
        
        if ($type == "purchase") {
            $productVariant->purchase_price = $purchaseDetail["purchase_price"];
            $productVariant->price = $purchaseDetail["price"];
        }
        else {
            $productVariant->stock = $productVariant->stock - $purchaseDetail["quantity"];
        }
        
        $productVariant->save();
    }
}
