<?php

namespace App\Services;

use App\Models\PurchasePayment;
use App\Services\PurchaseService;
use Illuminate\Database\Eloquent\Collection;

use DB;

class PurchasePaymentService
{
    protected $purchaseService;

    public function __construct(PurchaseService $purchaseService)
    {
        $this->purchaseService = $purchaseService;
    }

    public function list($purchaseId)
    {
        return PurchasePayment::orderBy('payment_date', 'asc')
                            ->where('purchase_id', $purchaseId)
                            ->get();
    }

    public function create(array $data)
    {
        $purchase = $this->purchaseService->getByid($data['purchase_id']);

        $totalToPay = number_format($purchase->total_amount - $purchase->advance_payment, 2);

        if($data['amount'] > $totalToPay)
            return false;

        return DB::transaction(function () use ($data) {
            $this->purchaseService->updateAdvancePayment($data['purchase_id'], $data['amount']);

            $data['payment_date'] = date('Y-m-d');

            return PurchasePayment::create($data);
        });
    }

    public function delete(int $id): bool
    {
        $purchasePayment = PurchasePayment::find($id);
        return $purchasePayment ? $purchasePayment->delete() : false;
    }
}
