<?php

namespace App\Services;

use Illuminate\Database\Eloquent\Collection;
use App\Models\User;
use Spatie\Permission\Models\Role;

use DB;
use Hash;

class RoleService 
{
    public function list($request)
    {
        if ($request->action && $request->action == 'export') {
            return Role::with('users')
                            ->orderBy('name', 'asc')
                        ->where('name', 'like', '%'. $request->search .'%')
                        ->get();

        }

        return Role::with('users')
                        ->orderBy('name', 'asc')
                        ->where('name', 'like', '%'. $request->search .'%')
                        ->paginate(20);
    }

    public function getAll(): Collection
    {
        return User::all();
    }
 
    public function getById(int $id): ?User
    {
        return User::with('roles')->find($id);
    }

    public function create($data)
    {
        $permissionsID = array_map(
            function($value) { return (int)$value; },
            $data->input('permissions')
        );
        
        $role = Role::create(['user_id' => $data->input('user_id'), 'name' => $data->input('name')]);
        $role->syncPermissions($permissionsID);

        return $role;
    }

    public function update($id, $data)
    {
        $role = Role::find($id);
        $role->user_id = $data->input('user_id');
        $role->name = $data->input('name');
        $role->save();

        $permissionsID = array_map(
            function($value) { return (int)$value; },
            $data->input('permissions')
        );
    
        $role->syncPermissions($permissionsID);

        return $role;
    }

    public function delete($id)
    {
        $role = Role::find($id);

        return $role ? $role->delete() : false;
    }

    public function getByName(string $name): ?Role
    {
        return Role::where('name', $name)->first();
    }
}
