<?php

namespace App\Services;

use App\Models\Sale;
use App\Models\SaleDetail;
use App\Services\ProductService;
use Illuminate\Support\Facades\DB;

class SaleDetailService
{
    public function list($saleId)
    {
        return SaleDetail::with(['sale.customer'])
                        ->where('sale_id', $saleId)
                        ->get();
    }

    public function getById($id)
    {
        return SaleDetail::find($id);
    }

    public function addToSupplier($data)
    {
        return DB::transaction(function () use ($data) {
            foreach ($data['saleDetailIds'] as $detail) {
                $saleDetail = $this->getById($detail);
                $saleDetail->supplier_id = $data['supplier_id'];
                $saleDetail->send_status = 'toSend';
                $saleDetail->save();
            }
        });
    }

    public function removeToSupplier($id)
    {
        $saleDetail = $this->getById($id);
        $saleDetail->supplier_id = null;
        $saleDetail->send_status = 'available';
        $saleDetail->save();
    }

    public function listToSend($supplierId)
    {
        return SaleDetail::with(['sale.customer'])
                        ->where('supplier_id', $supplierId)
                        ->where('send_status', 'toSend')
                        ->get();
    }

    public function updateStatusToSent($id)
    {
        $saleDetail = SaleDetail::find($id);
        $saleDetail->send_status = 'sent';
        $saleDetail->save();
    }
}
