<?php

namespace App\Services;

use App\Models\SalePayment;
use App\Services\SaleService;
use Illuminate\Database\Eloquent\Collection;

use DB;

class SalePaymentService
{
    protected $saleService;

    public function __construct(SaleService $saleService)
    {
        $this->saleService = $saleService;
    }

    public function list($saleId)
    {
        return SalePayment::orderBy('payment_date', 'asc')
                            ->where('sale_id', $saleId)
                            ->get();
    }

    public function create(array $data, $cashRegisterId)
    {
        $sale = $this->saleService->getByid($data['sale_id']);

        $totalToPay = $sale->total - $sale->advance_payment;

        if($data['amount'] > $totalToPay)
            return false;

        $data['cash_register_id'] = $cashRegisterId;
        
        return DB::transaction(function () use ($data) {
            $this->saleService->updateAdvancePayment($data['sale_id'], $data['amount']);

            $data['payment_date'] = date('Y-m-d');

            return SalePayment::create($data);
        });
    }

    public function delete(int $id): bool
    {
        $salePayment = SalePayment::find($id);
        return $salePayment ? $salePayment->delete() : false;
    }
}
