<?php

namespace App\Services;

use App\Models\StaffPayment;
use Illuminate\Database\Eloquent\Collection;

class StaffPaymentService
{
    public function list($request)
    {
        if ($request->action && $request->action == 'export') {
            return StaffPayment::with('employee', 'user')
                ->orderBy('payment_date', 'desc')
                ->when($request->search, function ($query, $search) {
                    $query->whereHas('employee', function ($q) use ($search) {
                        $q->where('first_name', 'like', "%$search%")
                          ->orWhere('last_name', 'like', "%$search%")
                          ->orWhere('document_number', 'like', "%$search%");
                    });
                })
                ->when($request->start_date && $request->end_date, function ($query) use ($request) {
                    $query->whereBetween('payment_date', [$request->start_date, $request->end_date]);
                })
                ->get();
        }

        return StaffPayment::with('employee', 'user')
            ->orderBy('payment_date', 'desc')
            ->when($request->search, function ($query, $search) {
                $query->whereHas('employee', function ($q) use ($search) {
                    $q->where('first_name', 'like', "%$search%")
                      ->orWhere('last_name', 'like', "%$search%")
                      ->orWhere('document_number', 'like', "%$search%");
                });
            })
            ->when($request->start_date && $request->end_date, function ($query) use ($request) {
                $query->whereBetween('payment_date', [$request->start_date, $request->end_date]);
            })
            ->paginate(20);
    }

    public function getAll(): Collection
    {
        return StaffPayment::with('employee', 'user')
                ->orderBy('payment_date', 'desc')
                ->get();
    }

    public function getById(int $id): ?StaffPayment
    {
        return StaffPayment::with('employee', 'user')->find($id);
    }

    public function create(array $data): StaffPayment
    {
        $data["operation_number"] = $data["operation_number"] ? $data["operation_number"]  : "";
        $data["notes"] = $data["notes"] ? $data["notes"]  : "";

        // aquí ya viene con user_id asignado en el controlador
        return StaffPayment::create($data);
    }

    public function update($id, $data): ?StaffPayment
    {
        $payment = StaffPayment::find($id);

        if ($payment) {
            $payment->update($data);
        }

        return $payment;
    }

    public function delete(int $id): bool
    {
        $payment = StaffPayment::find($id);
        return $payment ? $payment->delete() : false;
    }
}
