<?php

namespace App\Services;

use App\Models\Supplier;
use Illuminate\Database\Eloquent\Collection;

class SupplierService 
{
    public function list($request)
    {
        if ($request->action && $request->action == 'export') {
            return Supplier::orderBy('name', 'asc')
                        ->where('name', 'like', '%'. $request->search .'%')
                        ->get();
        }

        return Supplier::orderBy('name', 'asc')
                        ->where('name', 'like', '%'. $request->search .'%')
                        ->paginate(20);
    }

    public function getAll($request): Collection
    {
        return Supplier::get();
    }
 
    public function getById(int $id): ?Supplier
    {
        return Supplier::find($id);
    }

    public function create(array $data): Supplier
    {
        return Supplier::create($data);
    }

    public function update($id, $data): ?Supplier
    {
        $supplier = Supplier::find($id);
        if ($supplier) {
            $supplier->update($data);
        }

        return $supplier;
    }

    public function delete(int $id): bool
    {
        $supplier = Supplier::find($id);
        return $supplier ? $supplier->delete() : false;
    }
}
