<?php

namespace App\Services;

use Illuminate\Database\Eloquent\Collection;
use App\Models\User;
use Spatie\Permission\Models\Role;

use DB;
use Hash;

class UserService 
{
    public function list($request)
    {
        if ($request->action && $request->action == 'export') {
            return User::with(['branch', 'roles'])
                        ->orderBy('name', 'asc')
                        ->where('name', 'like', '%'. $request->search .'%')
                        ->orWhere('email', 'like', '%'. $request->search .'%')
                        ->get();
        }

        return User::with(['branch', 'roles'])
                        ->orderBy('name', 'asc')
                        ->where('name', 'like', '%'. $request->search .'%')
                        ->orWhere('email', 'like', '%'. $request->search .'%')
                        ->paginate(20);
    }

    public function getAll(): Collection
    {
        return User::all();
    }
 
    public function getById(int $id): ?User
    {
        return User::with('roles')->find($id);
    }

    public function getByEmail($email): ?User
    {
        return User::where('email', $email)->first();
    }

    public function getByRememberToken($token): ?User
    {
        return User::where('remember_token', $token)->first();
    }

    public function create(array $data): User
    {
        return User::create($data);
    }

    public function update($id, $data): ?User
    {
        $user = User::find($id);
        if ($user) {
            $user->update($data);
            DB::table('model_has_roles')->where('model_id', $id)->delete();    
            $user->assignRole($data['roles']);
        }

        return $user;
    }

    public function delete(int $id): bool
    {
        $user = User::find($id);
        return $user ? $user->delete() : false;
    }

    public function updateNewRememberToken(int $id)
    {
        $rememberToken = Hash::make(date('Y-m-d H:i:s'));

        $user = User::find($id);
        $user->remember_token = $rememberToken . $user->id;
        $user->save();

        return $rememberToken;
    }

    public function validatePasswords($request)
    {
        if($request->password == $request->passwordConfirm)
            return true;
        
        return false;
    }

    public function updatePassword($request)
    {
        $user = $this->getByRememberToken($request->token);
        $user->password = Hash::make($request->password);
        $user->remember_token = '';
        $user->save();
    }

    public function changePassword($request, $id)
    {
        $user = $this->getById($id);
        $user->password = Hash::make($request->password);
        $user->save();
    }
}
