import './bootstrap';

import { createApp, h } from 'vue'
import { createInertiaApp, Link } from '@inertiajs/vue3'
import Layout from './components/Layout.vue'

createInertiaApp({
  resolve: name => {
    const pages = require.context('./Pages', true, /\.vue$/);
    const page = pages(`./${name}.vue`).default;

    page.layout = page.layout || Layout;
    return page;
  },
  setup({ el, App, props, plugin }) {
    createApp({ render: () => h(App, props) })
      .use(plugin)
      .component('Link',Link)
      .mount(el)
  },
})