<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Glassmorphism Azul</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
    <style>
        body {
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            background: linear-gradient(135deg, #1e3c72, #2a5298);
        }
        .login-container {
            max-width: 400px;
            min-width: 350px;
            background: rgba(255, 255, 255, 0.1);
            padding: 2rem;
            border-radius: 15px;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2);
            text-align: center;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        .logo {
            max-width: 180px;
            margin-bottom: 10px;
        }
        .form-control {
            border-radius: 20px;
            background: rgba(255, 255, 255, 0.2);
            border: none;
            color: white;
        }
        .form-control::placeholder {
            color: rgba(255, 255, 255, 0.7);
        }
        .input-group-text {
            background: rgba(255, 255, 255, 0.2);
            border: none;
            color: white;
        }
        .btn {
            border-radius: 20px;
            background: rgba(255, 255, 255, 0.3);
            border: none;
            color: white;
            transition: 0.3s;
        }
        .btn:hover {
            background: rgba(255, 255, 255, 0.5);
        }
        .forgot-password a, p a {
            color: #fff;
            text-decoration: none;
        }
        .forgot-password a:hover, p a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>

    <div class="login-container">
        <img src="{{ asset('assets/img/logo.png') }}" alt="Logo de la empresa" class="logo">
        <h3 class="mb-4 text-white">Actualizar Contraseña</h3>
        @if (Session::has('error'))
            <div class="alert alert-danger">
                {{ Session::get('error') }}
            </div>
        @endif
        <form method="POST" action="{{ url('password-reset/confirmation') }}">
            @csrf
            <input type="hidden" name="token" value="{{ $user->remember_token}}">
            <div class="mb-3">
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-user"></i></span>
                    <input type="email" class="form-control" name="email" value="{{ $user->email }}" readonly>
                </div>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label text-white">Contraseña</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-lock"></i></span>
                    <input type="password" name="password" id="password" class="form-control" placeholder="••••••••" required>
                </div>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label text-white">Confirmar contraseña</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-lock"></i></span>
                    <input type="password" name="passwordConfirm" id="passwordConfirm" class="form-control" placeholder="••••••••" required>
                </div>
            </div>
            <button type="submit" class="btn w-100" style="background: #37a738; color: white;">Actualizar contraseña</button>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
