<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Consultas Médicas</title>
    <style>
        body { font-size: 12px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 4px; text-align: left; }
    </style>
</head>
<body>
    <h2>Reporte de Consultas Médicas</h2>
    <table>
        <thead>
            <tr>
                <th>Paciente</th>
                <th>Edad</th>
                <th>Fecha</th>
                <th>Precio</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($consultations as $c)
                <tr>
                    <td>{{ $c->patient_name }}</td>
                    <td>{{ $c->age }}</td>
                    <td>{{ $c->date }}</td>
                    <td>{{ number_format($c->price, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
