<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <style>
        @page {
            margin: 0;
        }

        body {
            font-family: 'Courier New', Courier, monospace;
            font-size: 11px;
            width: 80mm;
            margin: 0;
            padding: 0;
        }

        .ticket-container {
            padding: 5mm;
        }

        .center {
            text-align: center;
        }

        .logo {
            width: 90px;
            margin: 0 auto 5px;
            display: block;
        }

        .company-info {
            margin-bottom: 5px;
        }

        .line {
            border-top: 1px dashed #000;
            margin: 5px 0;
        }

        .small {
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 5px;
            font-size: 10px;
        }

        th, td {
            padding: 2px 0;
            text-align: left;
        }

        th {
            border-bottom: 1px solid black;
        }

        .total {
            font-weight: bold;
            margin-top: 8px;
            display: flex;
            justify-content: space-between;
        }

        .thankyou {
            margin-top: 5px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="ticket-container">

        {{-- LOGO --}}
        <!--
        <img src="./assets/img/logo.png" class="logo" style="display: none;"> -->

        {{-- INFORMACIÓN EMPRESA --}}
        <div class="company-info center small">
            <div><strong>{{ $setting->business_name }} - {{ $setting->ruc }}</strong></div>
            <div>Ticket # {{ str_pad($sale->id, 6, '0', STR_PAD_LEFT) }}</div>
            <div>Dirección: {{ $setting->address }}</div>
            <div>Celular: {{ $setting->phone }}</div>
        </div>

        <div class="line"></div>

        <div class="small"><strong>Fecha:</strong> {{ date('d/m/Y H:i:s', strtotime($sale->created_at)) }}</div>
        <div class="small"><strong>Cliente:</strong> {{ $sale->customer->first_name .' '. $sale->customer->last_name .' '. $sale->customer->middle_name }}</div>

        <div class="line"></div>

        {{-- TABLA DE DETALLES --}}
        <table>
            <thead>
                <tr>
                    <th style="width: 45%;">Producto</th>
                    <th style="width: 15%;">Cant</th>
                    <th style="width: 20%;">Precio</th>
                    <th style="width: 20%;">Importe</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($sale->details as $item)
                    <tr>
                        @if($item->product && $item->product_variant)
                            <td>
                                <b>{{ $item->product->name }}</b><br>
                                {{ $item->product_variant->size->name .' - '. $item->product_variant->color->name}}
                            </td>
                        @else
                            <td>
                                <b>{{ $item->product ? $item->product->name : $item->custom_name }}</b>
                            </td>
                        @endif

                        <td style="text-align: center;">{{ $item->quantity }}</td>
                        <td>{{ number_format($item->price, 2) }}</td>
                        <td style="text-align: right;">{{ number_format($item->quantity * $item->price, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="3" style="text-align: right;">
                        <b>Total:</b>
                    </td>
                    <td style="text-align: right;"><b>{{ number_format($sale->total, 2) }}</b></td>
                </tr>
            </tfoot>
        </table>

        <div class="line"></div>
        <div class="thankyou small">
            <b>Sucursal:</b> {{ $sale->branch->name }}
        </div>
        <div class="thankyou small">
            <b>Usuario:</b> {{ $sale->user->name }}
        </div>
        <div class="thankyou small">
            ¡Gracias por su compra!
        </div>
    </div>
</body>
</html>
