<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Comprobante de Venta</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #333;
            margin: 40px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .logo {
            width: 120px;
            margin-bottom: 10px;
        }

        .company-info {
            text-align: center;
            margin-bottom: 10px;
        }

        .company-info h2 {
            margin: 0;
            font-size: 20px;
            color: #2c3e50;
        }

        .company-info p {
            margin: 3px 0;
            font-size: 13px;
        }

        .invoice-title {
            text-align: center;
            margin-top: 10px;
            font-size: 18px;
            font-weight: bold;
            text-transform: uppercase;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        th, td {
            padding: 8px;
            border: 1px solid #ddd;
        }

        th {
            background-color: #f4f4f4;
        }

        .totals {
            margin-top: 20px;
            width: 100%;
        }

        .totals td {
            padding: 8px;
            border: none;
        }

        .totals .label {
            text-align: right;
            font-weight: bold;
            width: 85%;
        }

        .totals .value {
            text-align: right;
            font-weight: bold;
            color: #2c3e50;
        }

        .footer {
            text-align: center;
            font-size: 12px;
            color: #777;
            margin-top: 30px;
        }

        .details-table {
            margin-top: 10px;
        }

        .info-block {
            margin-top: 20px;
            display: flex;
            justify-content: space-between;
            font-size: 13px;
        }

        .info-block div {
            width: 48%;
        }
    </style>
</head>
<body>

    {{-- ENCABEZADO --}}
    <div class="header">
        @if(file_exists(public_path('assets/img/logo.png')))
            <img src="{{ public_path('assets/img/logo.png') }}" class="logo" alt="Logo">
        @endif
        <div class="company-info">
            <h2>{{ $setting->business_name }}</h2>
            <p>RUC: {{ $setting->ruc }}</p>
            <p>{{ $setting->address }}</p>
            <p>Celular: {{ $setting->phone }}</p>
        </div>
        <div class="invoice-title">COMPROBANTE DE VENTA</div>
        <p><strong>N°:</strong> {{ str_pad($sale->id, 6, '0', STR_PAD_LEFT) }}</p>
    </div>

    {{-- INFORMACIÓN DEL CLIENTE Y VENTA --}}
    <div class="info-block">
        <div>
            <p><strong>Cliente:</strong> {{ $sale->customer->first_name }} {{ $sale->customer->last_name }} {{ $sale->customer->middle_name }}</p>
            <p><strong>Documento:</strong> {{ $sale->customer->identity_card ?? '-' }}</p>
        </div>
        <div style="text-align: right;">
            <p><strong>Fecha:</strong> {{ date('d/m/Y H:i', strtotime($sale->created_at)) }}</p>
            <p><strong>Usuario:</strong> {{ $sale->user->name }}</p>
            <p><strong>Sucursal:</strong> {{ $sale->branch->name }}</p>
        </div>
    </div>

    {{-- TABLA DE DETALLES --}}
    <table class="details-table">
        <thead>
            <tr>
                <th>Producto</th>
                <th>Variante</th>
                <th style="text-align:center;">Cantidad</th>
                <th style="text-align:right;">Precio</th>
                <th style="text-align:right;">Importe</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($sale->details as $item)
                <tr>
                    <td>{{ $item->product ? $item->product->name : $item->custom_name }}</td>
                    <td>
                        @if($item->product_variant)
                            {{ $item->product_variant->size->name ?? '' }} / {{ $item->product_variant->color->name ?? '' }}
                        @else
                            -
                        @endif
                    </td>
                    <td style="text-align:center;">{{ $item->quantity }}</td>
                    <td style="text-align:right;">{{ number_format($item->price, 2) }}</td>
                    <td style="text-align:right;">{{ number_format($item->quantity * $item->price, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    {{-- TOTALES --}}
    <table class="totals">
        <tr>
            <td class="label">Total:</td>
            <td class="value">S/ {{ number_format($sale->total, 2) }}</td>
        </tr>
    </table>

    {{-- PIE DE PÁGINA --}}
    <div class="footer">
        <p>¡Gracias por su compra!</p>
        <p>Generado el {{ now()->format('d/m/Y H:i') }}</p>
    </div>

</body>
</html>
