<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Reporte de productos</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #333;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header h2 {
            margin: 0;
            font-size: 22px;
            color: #2c3e50;
        }

        .header small {
            color: #7f8c8d;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            padding: 8px 10px;
            border: 1px solid #ddd;
            text-align: center;
        }

        th {
            background-color: #f8f9fa;
            color: #2c3e50;
            font-size: 13px;
        }

        tbody tr:nth-child(even) {
            background-color: #fdfdfd;
        }

        .status-active {
            color: #fff;
            background: #27ae60;
            padding: 3px 6px;
            border-radius: 4px;
            font-size: 11px;
        }

        .status-inactive {
            color: #fff;
            background: #c0392b;
            padding: 3px 6px;
            border-radius: 4px;
            font-size: 11px;
        }

        .variant-table {
            width: 95%;
            margin: 8px auto;
            border: 1px solid #e0e0e0;
            border-radius: 6px;
            overflow: hidden;
        }

        .variant-table th {
            background-color: #eef2f7;
            font-size: 12px;
        }

        .variant-table td {
            font-size: 11px;
            padding: 6px;
        }

        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 2px solid #ccc;
            font-size: 14px;
            text-align: right;
        }
    </style>
</head>
<body>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 40px;">
    <!-- Logo -->
    <div style="flex: 1; float: left; width: 20%;">
        <img src="./assets/img/logo.png" alt="Logo" style="max-width: 100%; height: 100px;">
    </div>

    <!-- Título y fecha -->
    <div style="flex: 2; text-align: center; float: left; width: 80%; vertical-align: middle;">
        <div class="header">
            <h2>REPORTE DE PRODUCTOS</h2>
            <small>Generado el {{ \Carbon\Carbon::now()->format('d/m/Y H:i') }}</small>
        </div>
    </div>
</div>
<br><br><br><br>
<table>
    <thead>
        <tr>
            <th>Categoría</th>
            <th>Producto</th>
            <th>Marca</th>
            <th>Precio compra</th>
            <th>Precio venta</th>
            <th>Precio mínimo venta</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($products as $product)
            <tr>
                <td>{{ $product->category->name }}</td>
                <td>
                    <strong style="color: #48abf7;">{{ $product->supplier_barcode }}</strong><br>
                    <strong>{{ $product->name }}</strong>
                </td>
                <td>{{ $product->brand->name }}</td>
                <td style="color: red;">{{ $product->has_variants == 0 ? number_format($product->purchase_price, 2) : '' }}</td>
                <td style="color: green;">{{ $product->has_variants == 0 ? number_format($product->price, 2) : '' }}</td>
                <td style="color: blue;">{{ $product->has_variants == 0 ? number_format($product->min_price, 2) : '' }}</td>
            </tr>

            @if($product->has_variants == 0 && $product->branchStocks->count() > 0)
                <tr>
                    <td colspan="7">
                        <table class="variant-table">
                            <thead>
                                <tr>
                                    <th>Almacén</th>
                                    <th>Stock mínimo</th>
                                    <th>Stock</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($product->branchStocks as $branchStock)
                                    <tr>
                                        <td>{{ $branchStock->branch->name }}</td>
                                        <td>{{ $product->min_stock }}</td>
                                        <td>{{ $branchStock->stock }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </td>
                </tr>
            @elseif($product->variants->count() > 0)
                <tr>
                    <td colspan="7">
                        <table class="variant-table">
                            <thead>
                                <tr>
                                    <th>Tamaño</th>
                                    <th>Color</th>
                                    <th>Precio compra</th>
                                    <th>Precio venta</th>
                                    <th>Precio mínimo venta</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($product->variants as $variant)
                                    <tr>
                                        <td>{{ $variant->size->name }}</td>
                                        <td>{{ $variant->color->name }}</td>
                                        <td style="color: red;">{{ number_format($variant->purchase_price, 2) }}</td>
                                        <td style="color: green;">{{ number_format($variant->purchase_price, 2) }}</td>
                                        <td style="color: blue;">{{ number_format($variant->purchase_price, 2) }}</td>
                                    </tr>
                                    <tr>
                                        <td colspan="7">
                                            <table class="variant-table">
                                                <thead>
                                                    <tr>
                                                        <th>Almacén</th>
                                                        <th>Stock mínimo</th>
                                                        <th>Stock</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($product->branchStocks as $branchStock)
                                                        @if($variant->id == $branchStock->product_variant_id)
                                                            <tr>
                                                                <td>{{ $branchStock->branch->name }}</td>
                                                                <td>{{ $variant->min_stock }}</td>
                                                                <td>{{ $branchStock->stock }}</td>
                                                            </tr>
                                                        @endif
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </td>
                </tr>
            @endif
        @endforeach
    </tbody>
</table>

<div class="footer">
    <p style="margin: 5px 0; color: green;"><strong>Total productos:</strong> {{ count($products) }}</p>
</div>

</body>
</html>
