{{-- resources/views/pdf/proforma_header_color.blade.php --}}
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Contrato - Pedido #{{ $proforma->id }}</title>
    <style>
        @page { margin: 0; }

        body {
            font-family: "DejaVu Sans", sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 0;
            color: #333;
        }

        /* HEADER fijo */
        .header {
            position: fixed;
            top: 0; left: 0; right: 0;
            height: 130px;
            background: linear-gradient(90deg, #0d47a1 0%, #1976d2 40%, #42a5f5 100%);
            color: #fff;
            padding: 15px 30px;
            box-sizing: border-box;
        }

        .header .inner {
            display: table;
            width: 100%;
            table-layout: fixed;
        }
        .header .cell { display: table-cell; vertical-align: middle; }

        .logo { width: 120px; }
        .logo img { max-width: 100%; height: auto; display: block; }

        .title { text-align: center; padding: 0 10px; }
        .title h1 { margin: 0; font-size: 22px; }
        .title p { margin: 3px 0 0; font-size: 11px; }

        .company-info { text-align: right; font-size: 11px; }

        /* barra de acento debajo del header */
        .accent-bar {
            position: fixed;
            top: 130px;
            left: 0; right: 0;
            height: 8px;
            background: linear-gradient(90deg, #ff8a65, #ff7043);
        }

        /* CONTENIDO (lo bajamos para no chocar con header) */
        .content {
            margin-top: 10px;
            padding: 20px 30px;
        }

        .meta-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 12px;
            font-size: 12px;
        }
        .meta-table td { padding: 6px 8px; vertical-align: top; }

        .items {
            width: 100%;
            border-collapse: collapse;
            margin-top: 8px;
        }
        .items th {
            background: #1976d2;
            color: #fff;
            padding: 8px;
            font-size: 12px;
            text-align: left;
        }
        .items td {
            border: 1px solid #e0e0e0;
            padding: 8px;
            font-size: 11px;
            vertical-align: top;
        }

        .totals { width: 100%; margin-top: 8px; font-size: 12px; }
        .totals .label { text-align: right; padding-right: 10px; }
        .totals .value { width: 160px; text-align: right; padding-right: 6px; }

        .terms { margin-top: 14px; font-size: 11px; color: #444; }

        .signatures { margin-top: 40px; width: 100%; text-align: center; }
        .sign-block { display: inline-block; width: 40%; margin: 0 4%; }
        .sign-line {
            margin-top: 60px;
            border-top: 1px solid #bbb;
            padding-top: 6px;
            font-size: 12px;
            color: #222;
        }
    </style>
</head>
<body>
    {{-- HEADER --}}
    <table width="100%" style="background-color:#1976d2; color:#fff; padding:10px;">
        <tr>
            {{-- Logo --}}
            <td style="width:25%; text-align:left;">
                <img src="./assets/img/logo.jpg" alt="Logo" style="width:100%; height: 130px;">
            </td>

            {{-- Título --}}
            <td style="width:50%; text-align:center;">
                <h1 style="margin:0; font-size:22px;">CONTRATO DE PEDIDO</h1>
                <p style="margin:4px 0 0; font-size:16px;">
                    Pedido Nº <strong>{{ str_pad($proforma->id, 6, '0', STR_PAD_LEFT) }}</strong><br>
                    Fecha: {{ $proforma->created_at->format('d/m/Y') }}
                </p>
            </td>

            {{-- Datos empresa --}}
            <td style="width:25%; text-align:right; font-size:12px;">
                <strong>MUEBLECENTRO</strong><br>
                RUC: 20607402435<br>
                JR. MARISCAL GAMARRA 410 — ABANCAY<br>
                Tel: 916647636 • 944476331<br>
                <span style="font-size:11px;">MUEBLECENTRO.ABANCAY@GMAIL.COM</span>
            </td>
        </tr>
    </table>

    {{-- CONTENIDO --}}
    <div class="content">
        {{-- Datos cliente / pedido --}}
        <table class="meta-table">
            <tr>
                <td style="width:60%;">
                    <strong>Cliente:</strong> {{ $proforma->customer->first_name .' '. $proforma->customer->last_name .' '. $proforma->customer->middle_name }}<br>
                    <strong>Documento:</strong> {{ $proforma->customer->identity_card }}<br>
                    <strong>Dirección:</strong> {{ $proforma->customer->phone_number }}
                </td>
                <td style="width:40%; text-align:right;">
                    <strong>Fecha de entrega:</strong><br>
                    {{ $proforma->delivery_date ? \Carbon\Carbon::parse($proforma->delivery_date)->format('d/m/Y') : '-' }}<br><br>
                    <strong>Servicio amoblado:</strong><br>
                    {{ $proforma->has_furniture_service ? 'Sí' : 'No' }}
                </td>
            </tr>
        </table>

        {{-- Tabla de items --}}
        <table class="items">
            <thead>
                <tr>
                    <th style="width:8%;">Cant.</th>
                    <th style="width:62%;">Descripción</th>
                    <th style="width:15%;">P. Unitario</th>
                    <th style="width:15%;">Importe</th>
                </tr>
            </thead>
            <tbody>
                @foreach($proforma->items as $item)
                <tr>
                    <td>{{ $item->quantity }}</td>
                    <td>
                        <b>{{ $item->product_name ? $item->product_name : $item->custom_name }}</b><br>
                        {{ $item->size ? $item->size .' - '. $item->color : '' }}
                        @if(!empty($item->custom_description))
                            <div style="margin-top:6px;font-size:11px;color:#555;">{{ $item->custom_description }}</div>
                        @endif
                        @if(!empty($item->custom_measurements))
                            <div style="margin-top:4px;font-size:11px;color:#555;"><em><b>Medidas:</b></em> {{ $item->custom_measurements }}</div>
                        @endif
                    </td>
                    <td style="text-align:right;">{{ number_format($item->price,2) }}</td>
                    <td style="text-align:right;">{{ number_format($item->quantity * $item->price,2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        {{-- Totales --}}
        <table class="totals">
            <tr>
                <td class="label"></td>
                <td class="value">
                    <div style="border-top:2px solid #1976d2; padding-top:6px;">
                        <div style="display:flex; justify-content:space-between;">
                            <div style="flex:1; color:#444; font-weight:600;">TOTAL</div>
                            <div style="width:150px; text-align:right; font-weight:700;">{{ number_format($proforma->total,2) }}</div>
                        </div>
                        <div style="display:flex; justify-content:space-between; margin-top:6px;">
                            <div style="flex:1; color:#666;">Adelanto</div>
                            <div style="width:150px; text-align:right;">{{ number_format($proforma->advance_amount ?? 0,2) }}</div>
                        </div>
                        <div style="display:flex; justify-content:space-between; margin-top:4px; font-size: 16px;">
                            <div style="flex:1; color:#222; font-weight:600;">Saldo</div>
                            <div style="width:150px; text-align:right; font-weight:600;">{{ number_format(($proforma->total - ($proforma->advance_amount ?? 0)),2) }}</div>
                        </div>
                    </div>
                </td>
            </tr>
        </table>

        {{-- Términos y condiciones --}}
        <div class="terms">
            <h3 style="color:#1976d2; margin:6px 0;">Términos y Condiciones</h3>
            <ol>
                <li>Oferta válida por 15 días calendario.</li>
                <li>Anticipo del 50% antes de la producción</li>
                <li>No hay devoluciones luego de la entrega o ejecución del servicio.</li>
                <li>Fechas de entrega pueden variar por fuerza mayor; la empresa notificará oportunamente.</li>
            </ol>
            <p style="color:#27ae60; font-weight:700; margin-top:8px;">¡Gracias por confiar en MUEBLECENTRO!</p>
        </div>

        {{-- Firmas --}}
        <div class="signatures">
            <div class="sign-block">
                <div class="sign-line">Firma del Cliente</div>
            </div>
            <div class="sign-block">
                <div class="sign-line">Firma de la Empresa</div>
            </div>
        </div>
    </div>
</body>
</html>
