<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Reporte de Compras</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #333;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header .logo {
            width: 120px;
        }

        .header h2 {
            margin: 0;
            font-size: 24px;
            color: #2c3e50;
        }

        .header small {
            color: #7f8c8d;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            padding: 8px 10px;
            border: 1px solid #ccc;
            text-align: center;
        }

        th {
            background-color: #f2f2f2;
            color: #2c3e50;
        }

        tfoot td {
            font-weight: bold;
            background-color: #f9f9f9;
        }

        .status-paid {
            color: green;
            font-weight: bold;
        }

        .status-unpaid {
            color: red;
            font-weight: bold;
        }
    </style>
</head>
<body>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 40px;">
    <!-- Logo -->
    <div style="flex: 1; float: left; width: 20%;">
        <img src="./assets/img/logo.png" alt="Logo" style="width: 100%; height: 120px;">
    </div>

    <!-- Título y fecha -->
    <div style="flex: 2; text-align: center; float: left; width: 80%; vertical-align: middle;">
        <div class="header">
            <div class="title">
                <h2>{{ $purchase->order_status != 'stored' ? 'COTIZACIÓN DE COMPRA' : 'COMPRA'}}</h2>
                <small>Generado el {{ \Carbon\Carbon::now()->format('d/m/Y H:i') }}</small>
                <h4>
                    N° {{ str_pad($purchase->id, 8, "0", STR_PAD_LEFT) }}
                </h4>
            </div>
        </div>
    </div>
</div>
<br><br><br><br><br><br>
<table>
    <thead>
        <tr>
            <td>Fecha</td>
            <td>{{ \Carbon\Carbon::parse($purchase->date)->format('d/m/Y') }}</td>
        </tr>
        <tr>
            <td>Proveedor</td>
            <td>{{ $purchase->supplier->name }}</td>
        </tr>

        <tr>
            <td>N° de Factura</td>
            <td>{{ $purchase->invoice_number }}</td>
        </tr>

        <tr style="display: none;">
            <td>Pago</td>
            <td>
                @if($purchase->payment_status == 'unpaid')
                    <span class="badge badge-primary">
                        {{ $purchase->unpaid_at }}<br>
                        {{ $purchase->unpaid_at }} <br>
                    </span>
                @elseif($purchase->payment_status == 'partial')
                    <span class="badge badge-warning">
                        {{ $purchase->partial_at }}<br>
                        {{ $purchase->partial_at }} <br>
                    </span>
                @elseif($purchase->payment_status == 'paid')
                    <span class="badge badge-success">
                        {{ $purchase->paid_at }}<br>
                        {{ $purchase->paid_at }} <br>
                    </span>
                @endif
            </td>
        </tr>
        <tr style="display: none;">
            <td>Pedido</td>
            <td>
                @if($purchase->order_status == 'new')
                    <span class="badge badge-primary">
                        {{ $purchase->new_at }}<br>
                        {{ $purchase->new_at }} <br>
                    </span>
                @elseif($purchase->order_status == 'confirmed')
                    <span class="badge badge-info">
                        {{ $purchase->confirmed_at }}<br>
                        {{ $purchase->confirmed_at }} <br>
                    </span>
                @elseif($purchase->order_status == 'to_pickup')
                    <span class="badge badge-warning">
                        {{ $purchase->to_pickup_at }}<br>
                        {{ $purchase->to_pickup_at }} <br>
                    </span>
                @elseif($purchase->order_status == 'stored')
                    <span class="badge badge-success">
                        {{ $purchase->stored_at }}<br>
                        {{ $purchase->stored_at }} <br>
                    </span>
                @endif
            </td>
        </tr>
        <tr>
            <td>Adelanto</td>
            <td>
                <b>S/{{ $purchase->advance_payment }}</b>
            </td>
        </tr>
        <tr>
            <td>Saldo</td>
            <td>
                <b>S/{{ number_format($purchase->total_amount - $purchase->advance_payment, 2) }}</b>
            </td>
        </tr>
        <tr>
            <td>Total</td>
            <td>
                <b>S/{{ $purchase->total_amount }}</b>
            </td>
        </tr>
    </thead>
</table>
<table>
    <thead>
        <tr>
            <th>Producto</th>
            <th>Variante</th>
            <th>Cantidad</th>
            <th>P.Unit</th>
            <th>Total</th>
        </tr>
    </thead>
    <tbody>
        @foreach($purchase->details as $detail)
            <tr>
                <td>{{ $detail->product_name }}</td>
                <td>{{ $detail->size ? $detail->size .' - '. $detail->color : '' }}</td>
                <td>
                    {{ $detail->quantity }}
                </td>
                <td>
                    {{ $detail->purchase_price }}
                </td>
                <td>
                    {{ $detail->subtotal }}
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
</body>
</html>
