<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Reporte de ventas</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #333;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header .logo {
            width: 120px;
        }

        .header h2 {
            margin: 0;
            font-size: 24px;
            color: #2c3e50;
        }

        .header small {
            color: #7f8c8d;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            padding: 8px 10px;
            border: 1px solid #ccc;
            text-align: center;
        }

        th {
            background-color: #f2f2f2;
            color: #2c3e50;
        }

        tfoot td {
            font-weight: bold;
            background-color: #f9f9f9;
        }

        .status-paid {
            color: green;
            font-weight: bold;
        }

        .status-unpaid {
            color: red;
            font-weight: bold;
        }
    </style>
</head>
<body>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 40px;">
    <!-- Logo -->
    <div style="flex: 1; float: left; width: 20%;">
        <img src="./assets/img/logo.png" alt="Logo" style="max-width: 100%;">
    </div>

    <!-- Título y fecha -->
    <div style="flex: 2; text-align: center; float: left; width: 80%; vertical-align: middle;">
        <div class="header">
            <div class="title">
                <h2>REPORTE DE VENTAS</h2>
                <small>Generado el {{ \Carbon\Carbon::now()->format('d/m/Y H:i') }}</small>
            </div>
        </div>
    </div>
</div>
<br><br><br><br><br><br>
<table>
    <thead>
        <tr>
            <th>Fecha</th>
            <th>Cliente</th>
            <th>Estado</th>
            <th>Fecha acción</th>
            <th>Adelanto</th>
            <th>Saldo</th>
            <th>Total</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($sales as $sale)
        <tr>
            <td>{{ \Carbon\Carbon::parse($sale->date)->format('d/m/Y') }}</td>
            <td>{{ $sale->customer->first_name .' '. $sale->customer->last_name .' '. $sale->customer->middle_name }}</td>
            <td class="status-{{ $sale->status }}">
                {{ $sale->status == 'paid' ? 'Pagado' : 'Pendiente' }}
            </td>
            <td>
                {{ $sale->status == 'paid' ? \Carbon\Carbon::parse($sale->completed_date)->format('d/m/Y') : \Carbon\Carbon::parse($sale->new_date)->format('d/m/Y') }}
            </td>
            <td>{{ number_format($sale->advance_payment, 2) }} DOP</td>
            <td>{{ number_format($sale->total - $sale->advance_payment, 2) }} DOP</td>
            <td>{{ number_format($sale->total, 2) }} DOP</td>
        </tr>
        @endforeach
    </tbody>
</table>

<div style="margin-top: 30px; padding-top: 15px; border-top: 2px solid #ccc; font-size: 14px; text-align: right;">
    <p style="margin: 5px 0; color: blue;"><strong>Total Adelanto:</strong> {{ number_format($totalAdvancePayment, 2) }} DOP</p>
    <p style="margin: 5px 0; color: red;"><strong>Total Saldo:</strong> {{ number_format($totalBalance, 2) }} DOP</p>
    <p style="margin: 5px 0; color: green;"><strong>Total:</strong> {{ number_format($totalGeneral, 2) }} DOP</p>
</div>
</body>
</html>
