<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Reporte de pagos al personal</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #333;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header .logo {
            width: 120px;
        }

        .header h2 {
            margin: 0;
            font-size: 24px;
            color: #2c3e50;
        }

        .header small {
            color: #7f8c8d;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            padding: 8px 10px;
            border: 1px solid #ccc;
            text-align: center;
        }

        th {
            background-color: #f2f2f2;
            color: #2c3e50;
        }

        tfoot td {
            font-weight: bold;
            background-color: #f9f9f9;
        }

        .status-activo {
            color: green;
            font-weight: bold;
        }

        .status-cancelado {
            color: red;
            font-weight: bold;
        }
    </style>
</head>
<body>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 40px;">
    <!-- Logo -->
    <div style="flex: 1; float: left; width: 20%;">
        <img src="./assets/img/logo.png" alt="Logo" style="max-width: 100%;">
    </div>

    <!-- Título y fecha -->
    <div style="flex: 2; text-align: center; float: left; width: 80%; vertical-align: middle;">
        <div class="header">
            <div class="title">
                <h2>REPORTE DE PAGOS A PERSONAL</h2>
                <small>Generado el {{ \Carbon\Carbon::now()->format('d/m/Y H:i') }}</small>
            </div>
        </div>
    </div>
</div>

<br><br><br><br><br><br>

<table>
    <thead>
        <tr>
            <th>Empleado</th>
            <th>Monto</th>
            <th>Fecha de pago</th>
            <th>Método</th>
            <th>N° Operación</th>
            <th>Estado</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($staffPayments as $payment)
        <tr>
            <td>{{ $payment->employee->first_name .' '. $payment->employee->last_name }}</td>
            <td>{{ number_format($payment->amount, 2) }}</td>
            <td>{{ \Carbon\Carbon::parse($payment->payment_date)->format('d/m/Y') }}</td>
            <td>{{ $payment->method }}</td>
            <td>{{ $payment->operation_number ?? '-' }}</td>
            <td>
                <span class="status-{{ $payment->status }}">
                    {{ ucfirst($payment->status) }}
                </span>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>

<div style="margin-top: 30px; padding-top: 15px; border-top: 2px solid #ccc; font-size: 14px; text-align: right;">
    <p style="margin: 5px 0; color: green;">
        <strong>Total pagos:</strong> {{ count($staffPayments) }}
    </p>
    <p style="margin: 5px 0; color: blue;">
        <strong>Total desembolsado:</strong> {{ number_format($staffPayments->sum('amount'), 2) }}
    </p>
</div>

</body>
</html>
