@extends('layouts.app')

@section('content')
<div class="container">
    <div class="page-inner">
        <div
            class="d-flex align-items-left align-items-md-center flex-column flex-md-row pt-2 pb-4"
        >
            <div>
                <h3 class="fw-bold mb-3">Roles</h3>
                <h6 class="op-7 mb-2">Lista de roles</h6>
            </div>
            <div class="ms-md-auto py-2 py-md-0">
                <a href="#" class="btn btn-label-info btn-round me-2">Exportar</a>
                <Link href="/categories/create">
                    <a href="{{ route('roles.create') }}" class="btn btn-primary btn-round">
                        <i class="fas fa-plus"></i> Agregar rol
                    </a>
                </Link>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                    @session('success')
                        <div class="alert alert-success" role=" alert"> 
                            {{ $value }}
                        </div>
                    @endsession
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th scope="col">Nombre</th>
                                    <th scope="col">Acciones</th>
                                </tr>
                            </thead>
                            @foreach ($roles as $key => $role)
                                <tr>
                                    <td>{{ $role->name }}</td>
                                    <td>
                                        <a href="{{ route('roles.edit',$role->id) }}" class="btn btn-primary btn-sm" title="Editar rol">
                                            <i class="fa fa-edit"></i>
                                        </a>
                                        <form method="POST" action="{{ route('roles.destroy', $role->id) }}" style="display:inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" title="Eliminar rol">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </table>
                        {!! $roles->links('pagination::bootstrap-5') !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection