@extends('layouts.app')

@section('content')
<div class="container">
    <div class="page-inner">
        <div
                class="d-flex align-items-left align-items-md-center flex-column flex-md-row pt-2 pb-4"
            >
            <div>
                <h3 class="fw-bold mb-3">Editar usuario: {{ $user->email }}</h3>
                <h6 class="op-7 mb-2">El siguiente formulario permite actualizar la información del usuario.</h6>
            </div>
            <div class="ms-md-auto py-2 py-md-0">
                <Link href="/categories">
                    <a href="{{ route('users.index') }}" class="btn btn-black btn-round">
                        <i class="fas fa-arrow-left"></i> Volver
                    </a>
                </Link>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                    @session('success')
                        <div class="alert alert-success" role=" alert"> 
                            {{ $value }}
                        </div>
                    @endsession
                    
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                        <strong>Whoops!</strong> There were some problems with your input.<br><br>
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('users.update', $user->id) }}">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <div class="col-xs-12 col-sm-12 col-md-12">
                                <div class="form-group">
                                    <strong>Nombre completo:</strong>
                                    <input type="text" name="name" placeholder="Nombre completo..." class="form-control" value="{{ $user->name }}">
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-12 col-md-12">
                                <div class="form-group">
                                    <strong>Correo electrónico:</strong>
                                    <input type="email" name="email" placeholder="Correo electrónico" class="form-control" value="{{ $user->email }}">
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-12 col-md-12">
                                <div class="form-group">
                                    <strong>Role:</strong>
                                    <select name="roles[]" class="form-control" multiple="multiple">
                                        @foreach ($roles as $value => $label)
                                            <option value="{{ $value }}" {{ isset($userRole[$value]) ? 'selected' : ''}}>
                                                {{ $label }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-12 col-md-12">
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary btn-sm mt-2 mb-3"><i class="fa-solid fa-floppy-disk"></i> Guardar</button>
                                </div>
                            </div>
                        </div>
                    </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection