@extends('layouts.app')

@section('content')
<div class="container">
    <div class="page-inner">
        <div
            class="d-flex align-items-left align-items-md-center flex-column flex-md-row pt-2 pb-4"
        >
            <div>
                <h3 class="fw-bold mb-3">Usuarios</h3>
                <h6 class="op-7 mb-2">Lista de usuarios</h6>
            </div>
            <div class="ms-md-auto py-2 py-md-0">
                <a href="#" class="btn btn-label-info btn-round me-2">Exportar</a>
                <Link href="/categories/create">
                    <a href="{{ route('users.create') }}" class="btn btn-primary btn-round">
                        <i class="fas fa-plus"></i> Agregar usuario
                    </a>
                </Link>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                    @session('success')
                        <div class="alert alert-success" role=" alert"> 
                            {{ $value }}
                        </div>
                    @endsession
                        <table class="table mt-3">
                            <thead>
                                <tr>
                                    <th scope="col">Nombre</th>
                                    <th scope="col">Descripción</th>
                                    <th scope="col">Rol</th>
                                    <th scope="col">Acciones</th>
                                </tr>
                            </thead>
                            @foreach ($data as $key => $user)
                                <tr>
                                    <td>{{ $user->name }}</td>
                                    <td>{{ $user->email }}</td>
                                    <td>
                                    @if(!empty($user->getRoleNames()))
                                        @foreach($user->getRoleNames() as $v)
                                        <label class="badge bg-success">{{ $v }}</label>
                                        @endforeach
                                    @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('users.edit',$user->id) }}" class="btn btn-primary btn-sm" title="Editar usuario">
                                            <i class="fa fa-edit"></i>
                                        </a>
                                        <form method="POST" action="{{ route('users.destroy', $user->id) }}" style="display:inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" title="Eliminar usuario">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </table>
                        {!! $data->links('pagination::bootstrap-5') !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection
