<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\{ FurnitureServiceController, StockAdjustmentController, UserController, RoleController };
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\{ StaffPaymentController, EmployeeController, BrandController, CashRegisterController, PaymentMethodController, ProformaController, BranchProductVariantController, ProductTransferController, BranchController, PurchaseDetailController, SizeController, ColorController, DashboardController, PurchasePaymentController, ProductCorrectionItemController, SaleDetailController, SalePaymentController, ProductVariantController, PurchaseController, SaleController, MedicalConsultationController, ProductCorrectionController };

Route::get('/dashboard/chart-data', [DashboardController::class, 'getChartData']);

Route::get('/roles', [RoleController::class, "list"]);
Route::post('/roles', [RoleController::class, "store"]);
Route::post('/roles/{id}', [RoleController::class, "update"]);
Route::delete('/roles/{id}', [RoleController::class, "destroy"]);

Route::get('/users', [UserController::class, "list"]);
Route::post('/users', [UserController::class, "store"]);
Route::post('/users/{id}', [UserController::class, "update"]);
Route::delete('/users/{id}', [UserController::class, "destroy"]);
Route::post('/users/change-password/{id}', [UserController::class, "changePassword"]);

Route::get('/colors', [ColorController::class, "list"]);

Route::get('/sizes', [SizeController::class, "list"]);

Route::get('/categories', [CategoryController::class, "list"]);
Route::post('/categories', [CategoryController::class, "store"]);
Route::get('/categories/{id}', [CategoryController::class, "show"]);
Route::put('/categories/{id}', [CategoryController::class, "update"]);
Route::delete('/categories/{id}', [CategoryController::class, "destroy"]);

Route::get('/brands', [BrandController::class, "list"]);
Route::post('/brands', [BrandController::class, "store"]);
Route::get('/brands/{id}', [BrandController::class, "show"]);
Route::post('/brands/{id}', [BrandController::class, "update"]);
Route::delete('/brands/{id}', [BrandController::class, "destroy"]);

Route::get('/products', [ProductController::class, "list"]);
Route::post('/products', [ProductController::class, "store"]);
Route::get('/products/{id}', [ProductController::class, "show"]);
Route::post('/products/{id}', [ProductController::class, "update"]);
Route::delete('/products/{id}', [ProductController::class, "destroy"]);

Route::get('/branches', [BranchController::class, "list"]);
Route::post('/branches', [BranchController::class, "store"]);
Route::get('/branches/{id}', [BranchController::class, "show"]);
Route::post('/branches/{id}', [BranchController::class, "update"]);
Route::delete('/branches/{id}', [BranchController::class, "destroy"]);

Route::get('/product-variants', [ProductVariantController::class, "list"]);
Route::post('/product-variants', [ProductVariantController::class, "store"]);
Route::get('/product-variants/{id}', [ProductVariantController::class, "show"]);
Route::post('/product-variants/{id}', [ProductVariantController::class, "update"]);
Route::delete('/product-variants/{id}', [ProductVariantController::class, "destroy"]);

Route::get('/clients', [ClientController::class, "list"]);
Route::post('/clients', [ClientController::class, "store"]);
Route::get('/clients/{id}', [ClientController::class, "show"]);
Route::post('/clients/{id}', [ClientController::class, "update"]);
Route::delete('/clients/{id}', [ClientController::class, "destroy"]);

Route::get('/employees', [EmployeeController::class, "list"]);
Route::post('/employees', [EmployeeController::class, "store"]);
Route::get('/employees/{id}', [EmployeeController::class, "show"]);
Route::post('/employees/{id}', [EmployeeController::class, "update"]);
Route::delete('/employees/{id}', [EmployeeController::class, "destroy"]);

Route::get('/suppliers', [SupplierController::class, "list"]);
Route::post('/suppliers', [SupplierController::class, "store"]);
Route::get('/suppliers/{id}', [SupplierController::class, "show"]);
Route::post('/suppliers/{id}', [SupplierController::class, "update"]);
Route::delete('/suppliers/{id}', [SupplierController::class, "destroy"]);

Route::get('/purchases', [PurchaseController::class, "list"]);
Route::post('/purchases', [PurchaseController::class, "store"]);
Route::get('/purchases/{id}', [PurchaseController::class, "show"]);
Route::get('/purchases/{id}/get-by-id', [PurchaseController::class, "getById"]);
Route::post('/purchases/{id}', [PurchaseController::class, "update"]);
Route::post('/purchases/update-status/{id}', [PurchaseController::class, "updateStatus"]);
Route::delete('/purchases/{id}', [PurchaseController::class, "destroy"]);
Route::get('/purchases/to-pay/list', [PurchaseController::class, "toPayList"]);

Route::get('/purchases/{puchaseId}/payments', [PurchasePaymentController::class, "list"]);
Route::post('/purchases/{puchaseId}/payments', [PurchasePaymentController::class, "store"]);
Route::delete('/purchases/payments/{paymentId}', [PurchasePaymentController::class, "destroy"]);

Route::delete('/purchases-detail/{paymentDetailI}', [PurchaseDetailController::class, "destroy"]);

Route::get('/sales', [SaleController::class, "list"]);
Route::post('/sales', [SaleController::class, "store"]);
Route::get('/sales/{id}', [SaleController::class, "show"]);
Route::post('/sales/{id}', [SaleController::class, "update"]);
Route::delete('/sales/{id}', [SaleController::class, "destroy"]);
Route::get('/sales/to-collect/list', [SaleController::class, "toCollectList"]);

Route::get('/sales/{saleId}/payments', [SalePaymentController::class, "list"]);
Route::post('/sales/{saleId}/payments', [SalePaymentController::class, "store"]);
Route::delete('/sales/payments/{paymentId}', [SalePaymentController::class, "destroy"]);

Route::get('/sales-details/{saleId}', [SaleDetailController::class, "list"]);
Route::post('/sales-details/add-to-supplier', [SaleDetailController::class, "addToSupplier"]);
Route::get('/sales-details/remove-to-supplier/{saleDetailId}', [SaleDetailController::class, "removeToSupplier"]);
Route::get('/sales-details/list-to-send/{supplier_id}', [SaleDetailController::class, "listToSend"]);

Route::get('/product-transfers', [ProductTransferController::class, "list"]);
Route::post('/product-transfers', [ProductTransferController::class, "store"]);
Route::get('/product-transfers/{id}', [ProductTransferController::class, "show"]);
Route::post('/product-transfers/{id}', [ProductTransferController::class, "update"]);
Route::delete('/product-transfers/{id}', [ProductTransferController::class, "destroy"]);
Route::get('/product-transfers/to-collect/list', [ProductTransferController::class, "toCollectList"]);

Route::get('/branch-product-stocks', [BranchProductVariantController::class, "list"]);
Route::get('/branch-product-stocks/{productId}/branches', [BranchProductVariantController::class, "listByProduct"]);
Route::get('/branch-product-stocks/update-stock/{branchProductVariantId}', [BranchProductVariantController::class, "updateStockSuperAdmin"]);
 
Route::get('/proformas', [ProformaController::class, "list"]);
Route::post('/proformas', [ProformaController::class, "store"]);
Route::post('/proformas/{id}', [ProformaController::class, "update"]);
Route::delete('/proformas/{id}', [ProformaController::class, "destroy"]);
Route::post('/proformas/confirm-order/{id}', [ProformaController::class, "confirmOrder"]);
Route::post('/proformas/convert-to-sale/{id}/{userId}/{branchId}/{cashRegisterId}', [ProformaController::class, "convertToSale"]);
Route::delete('/proformas/delete-item/{itemId}', [ProformaController::class, "deleteItem"]);

Route::get('/payment-methods', [PaymentMethodController::class, "list"]);

Route::get('/cash-registers', [CashRegisterController::class, "list"]);
Route::post('/cash-registers', [CashRegisterController::class, "store"]);
Route::get('/cash-registers/{id}/close/{userId}', [CashRegisterController::class, "close"]);

Route::get('/stock-adjustments/{branchStock}', [StockAdjustmentController::class, "list"]);

Route::get('/furnishing-services', [FurnitureServiceController::class, "list"]);
Route::post('/furnishing-services', [FurnitureServiceController::class, "store"]);
Route::get('/furnishing-services/{id}', [FurnitureServiceController::class, "show"]);
Route::post('/furnishing-services/{id}', [FurnitureServiceController::class, "update"]);
Route::delete('/furnishing-services/{id}', [FurnitureServiceController::class, "destroy"]);

Route::get('/staff-payments', [StaffPaymentController::class, "list"]);
Route::post('/staff-payments', [StaffPaymentController::class, "store"]);
Route::get('/staff-payments/{id}/cancel', [StaffPaymentController::class, "cancel"]);
Route::get('/staff-payments/export-pdf', [StaffPaymentController::class, "cancel"]);