<?php

use Inertia\Inertia;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\HomeController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\{ StaffPaymentController, EmployeeController, CashRegisterController, ProformaController, ProductTransferController, BranchController, ProductVariantController, PurchaseController, SaleController, MedicalConsultationController, ProductCorrectionController,FurnitureServiceController };

Route::get('/dashboard', function () {
    return Inertia::render('Inicio', ["titulo" => "title"]);
});

Route::get('/contacto', function () {
    return Inertia::render('Contacto');
});
Auth::routes();

Route::get('/', function () {
    return view('auth/login');
}); 

Route::get('password-reset', function () {
    return view('auth/passwords/reset');
});
Route::post('password-reset', [UserController::class, "PasswordReset"]);
Route::get('password-reset/confirmation', [UserController::class, "ConfirmationPassword"]);
Route::post('password-reset/confirmation', [UserController::class, "ConfirmationPassword"]);

Route::group(['middleware' => ['auth']], function() {
    Route::get('/home', [HomeController::class, 'index'])->name('home');
    Route::get('/dashboard', [HomeController::class, 'index'])->name('home');

    Route::resource('roles', RoleController::class);
    Route::get('roles/create', [RoleController::class, "create"]);
    Route::get('roles/edit/{id}', [RoleController::class, "edit"]);
    Route::get('roles/export/pdf', [RoleController::class, "exportPDF"]);
    Route::get('roles/export/excel', [RoleController::class, "exportExcel"]);

    Route::get('branches', [BranchController::class, "index"]);
    Route::get('branches/create', [BranchController::class, "create"]);
    Route::get('branches/edit/{id}', [BranchController::class, "edit"]);
    Route::get('branches/export-pdf', [BranchController::class, "exportPDF"]);
    Route::get('branches/export-excel', [BranchController::class, "exportExcel"]);

    Route::get('categories', [CategoryController::class, "index"]);
    Route::get('categories/create', [CategoryController::class, "create"]);
    Route::get('categories/edit/{id}', [CategoryController::class, "edit"]);
    Route::get('categories/export-pdf', [CategoryController::class, "exportPDF"]);
    Route::get('categories/export-excel', [CategoryController::class, "exportExcel"]);

    Route::get('products', [ProductController::class, "index"]);
    Route::get('products/create', [ProductController::class, "create"]);
    Route::get('products/edit/{id}', [ProductController::class, "edit"]);
    Route::get('products/export-pdf', [ProductController::class, "exportPDF"]);
    Route::get('products/export-excel', [ProductController::class, "exportExcel"]);

    Route::get('product-variants/{id}', [ProductVariantController::class, "index"]);
    Route::get('product-variants/create/{productId}', [ProductVariantController::class, "create"]);
    Route::get('product-variants/edit/{id}', [ProductVariantController::class, "edit"]);

    Route::get('clients', [ClientController::class, "index"]);
    Route::get('clients/create', [ClientController::class, "create"]);
    Route::get('clients/edit/{id}', [ClientController::class, "edit"]);
    Route::get('clients/export-pdf', [ClientController::class, "exportPDF"]);
    Route::get('clients/export-excel', [ClientController::class, "exportExcel"]);

    Route::get('suppliers', [SupplierController::class, "index"]);
    Route::get('suppliers/create', [SupplierController::class, "create"]);
    Route::get('suppliers/edit/{id}', [SupplierController::class, "edit"]);
    Route::get('suppliers/export-pdf', [SupplierController::class, "exportPDF"]);
    Route::get('suppliers/export-excel', [SupplierController::class, "exportExcel"]);

    Route::get('employees', [EmployeeController::class, "index"]);
    Route::get('employees/create', [EmployeeController::class, "create"]);
    Route::get('employees/edit/{id}', [EmployeeController::class, "edit"]);
    Route::get('employees/export-pdf', [EmployeeController::class, "exportPDF"]);
    Route::get('employees/export-excel', [EmployeeController::class, "exportExcel"]);

    Route::get('users', [UserController::class, "index"]);
    Route::get('users/create', [UserController::class, "create"]);
    Route::get('users/edit/{id}', [UserController::class, "edit"]);
    Route::get('users/change-password', [UserController::class, "viewChangePassword"]);
    Route::get('users/export-pdf', [UserController::class, "exportPDF"]);
    Route::get('users/export-excel', [UserController::class, "exportExcel"]);

    Route::get('purchases', [PurchaseController::class, "index"]);
    Route::get('purchases/create', [PurchaseController::class, "create"]);
    Route::get('purchases/edit/{id}', [PurchaseController::class, "edit"]);
    Route::get('purchases/show/{id}', [PurchaseController::class, "show"]);
    Route::get('purchases/export-pdf', [PurchaseController::class, "exportPDF"]);
    Route::get('purchases/export-excel', [PurchaseController::class, "exportExcel"]);
    Route::get('purchases/export-pdf-detail/{purchaseId}', [PurchaseController::class, "exportPDFQuote"]);

    Route::get('sales', [SaleController::class, "index"]);
    Route::get('sales/create', [SaleController::class, "create"]);
    Route::get('sales/edit/{id}', [SaleController::class, "edit"]);
    Route::get('sales/show/{id}', [SaleController::class, "show"]);
    Route::get('sales/export-pdf', [SaleController::class, "exportPDF"]);
    Route::get('sales/export-excel', [SaleController::class, "exportExcel"]);
    Route::get('sales/print-ticket/{id}', [SaleController::class, "printTicket"]);

    Route::get('product-transfers', [ProductTransferController::class, "index"]);
    Route::get('product-transfers/create', [ProductTransferController::class, "create"]);
    Route::get('product-transfers/edit/{id}', [ProductTransferController::class, "edit"]);
    Route::get('product-transfers/show/{id}', [ProductTransferController::class, "show"]);
    Route::get('product-transfers/export-pdf', [ProductTransferController::class, "exportPDF"]);
    Route::get('product-transfers/export-excel', [ProductTransferController::class, "exportExcel"]);

    Route::get('proformas', [ProformaController::class, "index"]);
    Route::get('proformas/create', [ProformaController::class, "create"]);
    Route::get('proformas/edit/{id}', [ProformaController::class, "edit"]);
    Route::get('proformas/show/{id}', [ProformaController::class, "show"]);
    Route::get('proformas/export-pdf/by-id/{id}', [ProformaController::class, "exportPDFById"]);
    Route::get('proformas/export-excel', [ProformaController::class, "exportExcel"]);

    Route::get('cash-registers', [CashRegisterController::class, "index"]);
    Route::get('cash-registers/create', [CashRegisterController::class, "create"]);
    Route::get('cash-registers/edit/{id}', [CashRegisterController::class, "edit"]);
    Route::get('cash-registers/show/{id}', [CashRegisterController::class, "show"]);
    Route::get('cash-registers/export-pdf', [CashRegisterController::class, "exportPDF"]);
    Route::get('cash-registers/export-excel', [CashRegisterController::class, "exportExcel"]);

    Route::get('furnishing-services', [FurnitureServiceController::class, "index"]);
    Route::get('furnishing-services/create', [FurnitureServiceController::class, "create"]);
    Route::get('furnishing-services/edit/{id}', [FurnitureServiceController::class, "edit"]);
    Route::get('furnishing-services/show/{id}', [FurnitureServiceController::class, "show"]);
    Route::get('furnishing-services/export-pdf', [FurnitureServiceController::class, "exportPDF"]);
    Route::get('furnishing-services/export-excel', [FurnitureServiceController::class, "exportExcel"]);
    Route::get('furnishing-services/print-ticket/{id}', [FurnitureServiceController::class, "printTicket"]);

    Route::get('staff-payments', [StaffPaymentController::class, "index"]);
    Route::get('staff-payments/create', [StaffPaymentController::class, "create"]);
    Route::get('staff-payments/edit/{id}', [StaffPaymentController::class, "edit"]);
    Route::get('staff-payments/show/{id}', [StaffPaymentController::class, "show"]);
    Route::get('staff-payments/export-pdf', [StaffPaymentController::class, "exportPDF"]);
    Route::get('staff-payments/export-excel', [StaffPaymentController::class, "exportExcel"]);

    Route::get('/permissions/update', [App\Http\Controllers\PermissionController::class, 'index']);
    Route::get('/permissions/users-auth', [App\Http\Controllers\PermissionController::class, 'getPermissionUser']);
}); 

Auth::routes();

Route::get('/clear-cache', function () {
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('route:clear');

    return '✔️ Caché limpiada correctamente.';
});

Route::get('/ver-entorno', function () {
    return [
        'env' => app()->environment(),
        'url' => config('app.url'),
        'asset_url' => config('app.asset_url'),
    ];
});